<!DOCTYPE html>
<html lang="en">

<head>
    <?php
    include('check_session.php');
    include 'header.php';
    include 'finping.php';
    ?>
    <title>SRI ATHISAKTHI GROUPS</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSS -->
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="css/style.css">
    <!-- <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet"> -->

    <!-- JS -->
    <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script>
        $(function() {
            $("#datepicker, #datepicker1, #datepicker2").datepicker({
                dateFormat: 'dd-mm-yy',
                changeMonth: true,
                changeYear: true
            });
        });
    </script>
    <style>
        .table th,
        .table td {
            vertical-align: middle !important;
            text-align: center;
        }

        .btn-group .btn {
            margin-right: 5px;
        }
    </style>
</head>

<body>
    <div class="container mt-5">
        <h3 class="text-center mb-4" style="font-size: 28px;">Immovable Property List</h3>

        <?php
        // $host = "localhost";
        // $port = "5432";
        // $dbname = "your_database";
        // $user = "your_user";
        // $password = "your_password";

        // $conn = pg_connect("host=$host port=$port dbname=$dbname user=$user password=$password");

        // if (!$conn) {
        //     echo "<div class='alert alert-danger'>Failed to connect to database.</div>";
        //     exit;
        // }
        $cmpname = $_POST['cmpname'] ?? $_GET['cmpname'];
        $query = "
           WITH customer_ranked AS (
    SELECT
        sno,
        cmpname,
        cusname1,
        propplace,
        propvill,
          protype,
        salevalue,
        cusamount1,
        amount,
        rdate,
        pmode,
        ROW_NUMBER() OVER (PARTITION BY sno ORDER BY cusname1) AS rank
    FROM sac.immovableproperty where cmpname='$cmpname' 
),
top3_customers AS (
    SELECT * FROM customer_ranked WHERE rank <= 3
),
aggregated AS (
    SELECT
        sno,
        MIN(cmpname) AS cmpname,
        STRING_AGG(DISTINCT cusname1, ', ') AS top_customers,
        MIN(propplace) AS propplace,
        MIN(propvill) AS propvill,
        MIN(protype) AS protype,
        SUM(cusamount1::numeric) AS total_salevalue,
        SUM(amount::numeric) AS total_amount,
        MIN(rdate) AS rdate,
        STRING_AGG(DISTINCT pmode, ', ') AS pmodes
    FROM top3_customers
    GROUP BY sno
)
SELECT * FROM aggregated ORDER BY sno;

        ";

        $result = pg_query($db, $query);

        if (!$result) {
            echo "<div class='alert alert-danger'>Query failed: " . pg_last_error($db) . "</div>";
            exit;
        }

        $query1 = "
    SELECT 
        p.*,
        string_agg(DISTINCT m.personname, ', ') AS member_names,
        COALESCE(e.total_expense, 0) AS expense_amount
    FROM sac.proppurchase p

    LEFT JOIN sac.propurchasemembers m
        ON p.id = m.purchaseid

    LEFT JOIN (
        SELECT 
            purchase_id,
            SUM(amount::numeric) AS total_expense
        FROM sac.proppurexpense
        GROUP BY purchase_id
    ) e
        ON p.id = e.purchase_id

    WHERE p.cmpname = '$cmpname'
    GROUP BY p.id, e.total_expense
";

        $result1 = pg_query($db, $query1);


        ?>
        <?php
        // Currency formatter for Indian format
        function formatIndianCurrency($amount)
        {
            $amount = number_format((float)$amount, 2, '.', '');
            $decimal = substr($amount, -3);
            $num = substr($amount, 0, -3);
            $lastThree = substr($num, -3);
            $restUnits = substr($num, 0, -3);
            if ($restUnits != '') {
                $restUnits = preg_replace("/\B(?=(\d{2})+(?!\d))/", ",", $restUnits);
                $formatted = $restUnits . "," . $lastThree;
            } else {
                $formatted = $lastThree;
            }
            return "₹" . $formatted . $decimal;
        }
        ?>

        <div style="text-align:right; margin: 15px 0;">
            <a href="Agriculture1.php?cmpname=<?= urlencode($cmpname) ?>"
                style="padding: 8px 14px; background-color: #28a745; color: white;
              text-decoration: none; border-radius: 4px;">
                ➕ Add Purchase
            </a>
        </div>
        <table style="width: 100%; border-collapse: collapse; text-align: center; margin-top: 30px;">
            <thead>
                <tr style="background-color: #343a40; color: white;">
                    <th style="border: 1px solid #000; padding: 8px;">S.No</th>
                    <th style="border: 1px solid #000; padding: 8px;">Company Name</th>
                    <th style="border: 1px solid #000; padding: 8px;">Sellers List</th>
                    <th style="border: 1px solid #000; padding: 8px;">Property Type</th>
                    <th style="border: 1px solid #000; padding: 8px;">Property Place</th>
                    <th style="border: 1px solid #000; padding: 8px;">Property Village</th>
                    <!-- <th style="border: 1px solid #000; padding: 8px;">Total Sale Value</th> -->
                    <th style="border: 1px solid #000; padding: 8px;">Total Purchase Amount</th>
                    <th style="border: 1px solid #000; padding: 8px;">Registration Date</th>
                    <!-- <th style="border: 1px solid #000; padding: 8px;">Payment Modes</th> -->
                    <th style="border: 1px solid #000; padding: 8px;">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = pg_fetch_assoc($result)) { ?>
                    <tr>
                        <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row['sno']) ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row['cmpname']) ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row['top_customers']) ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row['protype']) ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row['propplace']) ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row['propvill']) ?></td>
                        <!-- <td style="border: 1px solid #000; padding: 8px;"><?= formatIndianCurrency($row['total_salevalue'] ?? 0) ?></td> -->
                        <td style="border: 1px solid #000; padding: 8px;"><?= formatIndianCurrency($row['total_amount'] ?? 0) ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= date('d-m-Y', strtotime($row['rdate'])) ?></td>
                        <!-- <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row['pmodes']) ?></td> -->
                        <td style="border: 1px solid #000; padding: 8px;">
                            <!-- <a href="view.php?sno=<?= $row['sno'] ?>" style="padding: 4px 8px; background-color: #17a2b8; color: white; text-decoration: none; margin-right: 5px;">View</a> -->
                            <!-- <a href="Agriculturesell.php?sno=<?= $row['sno'] ?>" style="padding: 4px 8px; background-color: #ffc107; color: black; text-decoration: none; margin-right: 5px;">Sell</a> -->
                            <a href="PropertyExpense.php?sno=<?= $row['sno'] ?>&cmpname=<?= urlencode($row['cmpname']) ?>"
                                style="padding: 4px 8px; background-color: #17a2b8; color: white;  text-decoration: none;">
                                Expense
                            </a>
                            <!-- <a href="delete.php?sno=<?= $row['sno'] ?>" style="padding: 4px 8px; background-color: #dc3545; color: white; text-decoration: none;" onclick="return confirm('Are you sure you want to delete this record?');">Delete</a> -->
                        </td>
                    </tr>
                <?php } ?>
                <?php while ($row1 = pg_fetch_assoc($result1)) { ?>
                    <tr>
                        <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row1['sno']) ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row1['cmpname']) ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= $row1['member_names'] ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= $row1['propertytype'] ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= $row1['proplace'] ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= $row1['provillage'] ?></td>
                        <!-- <td style="border: 1px solid #000; padding: 8px;"><?= formatIndianCurrency($row1['propertyvalue'] ?? 0) ?></td> -->
                        <td style="border: 1px solid #000; padding: 8px;"><?= formatIndianCurrency(($row1['purchasevalue'] ?? 0) + ($row1['expense_amount'] ?? 0)) ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?= date('d-m-Y', strtotime($row1['regdate'])) ?></td>
                        <!-- <td style="border: 1px solid #000; padding: 8px;"><?= htmlspecialchars($row1['pmodes']) ?></td> -->
                        <td style="border: 1px solid #000; padding: 8px;">
                            <!-- <a href="view.php?sno=<?= $row['sno'] ?>" style="padding: 4px 8px; background-color: #17a2b8; color: white; text-decoration: none; margin-right: 5px;">View</a> -->
                            <!-- <a href="Agriculturesell.php?id=<?= $row1['id'] ?>&cmpname=<?= urlencode($row1['cmpname']) ?>" style="padding: 4px 8px; background-color: #ffc107; color: black; text-decoration: none; margin-right: 5px;">Sell</a> -->
                            <a href="AgriPropertyExpense.php?id=<?= $row1['id'] ?>&cmpname=<?= urlencode($row1['cmpname']) ?>"
                                style="padding: 4px 8px; background-color: #17a2b8; color: white; 
          text-decoration: none;">
                                Expense
                            </a>
                            <!-- <a href="delete.php?sno=<?= $row['sno'] ?>" style="padding: 4px 8px; background-color: #dc3545; color: white; text-decoration: none;" onclick="return confirm('Are you sure you want to delete this record?');">Delete</a> -->
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</body>

</html>