@ECHO OFF

:: Prompt for backup file name
set /p BackFileName="Enter File Name: "

:: Set PostgreSQL password
set PGPASSWORD=sac

:: Add PostgreSQL bin to PATH
set PATH=%PATH%;C:\Program Files\PostgreSQL\16\bin

:: Force disconnect active connections
echo.Terminating existing connections to sac...
psql -U postgres -h 127.0.0.1 -p 5432 -d postgres -c "SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE datname = 'sac' AND pid <> pg_backend_pid();"

:: Drop database
echo.Dropping sac
dropdb --host=127.0.0.1 --port=5432 --username=postgres --if-exists sac

:: Create database
echo.Creating sac
createdb --host=127.0.0.1 --port=5432 --username=postgres sac

:: Drop default public schema to avoid duplicate creation error
psql -U postgres -h 127.0.0.1 -p 5432 -d sac -c "DROP SCHEMA public CASCADE;"

:: Change to backup folder
cd /d "%~dp0..\DBBackups\toolbackups"

:: Restore from backup
pg_restore --host=127.0.0.1 --port=5432 --username=postgres --dbname=sac --format=custom "%BackFileName%"

set /p DUMMY=Restore Successful. Hit ENTER to close...
