<?php
include('../check_session.php');
include "../finping.php";

$id = $_GET['id'] ?? '';
$pquery = "SELECT * FROM sac.proppurchase WHERE id = '$id' ORDER BY id LIMIT 10";
$presult = pg_query($db, $pquery);

$prow = pg_fetch_assoc($presult);
$cmpname = $prow['cmpname'] ?? '';
$sno = $prow['sno'] ?? '';
$pathirano = $prow['pathirano'] ?? '';
$regdate = !empty($prow['regdate']) ? date('d-m-Y', strtotime($prow['regdate'])) : '';
$propertyvalue = $prow['propertyvalue'] ?? '';
$propertytype = $prow['propertytype'] ?? '';
$provillage = $prow['provillage'] ?? '';
$proplace = $prow['proplace'] ?? '';
$regplace = $prow['regplace'] ?? '';
$regphone = $prow['regphone'] ?? '';
$writername = $prow['writername'] ?? '';
$writerphone = $prow['writerphone'] ?? '';
$partnername = $prow['partnername'] ?? '';
$pcode = $prow['pcode'] ?? '';
$landtype = $prow['landtype'] ?? '';
$governmentvalue = $prow['governmentvalue'] ?? '';
$marketvalue = $prow['marketvalue'] ?? '';
$otherdet = json_decode($prow['otherdet'], true) ?? [];
$surveydet = json_decode($prow['surveydet'], true) ?? [];
$pattadet = json_decode($prow['pattadet'], true) ?? [];

// Survey & Patta Totals
$surveyCount = count($surveydet);
$surveyExtent = array_sum(array_map(fn($s) => floatval($s['extent'] ?? 0), $surveydet));
$pattaCount = count($pattadet);
$pattaExtent = array_sum(array_map(fn($p) => floatval($p['extent'] ?? 0), $pattadet));

// Sales Data
$salesData = [];
$mresult = pg_query($db, "SELECT * FROM sac.propurchasemembers WHERE purchaseid='$id'");
while ($mrow = pg_fetch_assoc($mresult)) {
    $salesData[] = [
        'name' => $mrow['personname'],
        'amount' => $mrow['amount'],
        'pmode' => $mrow['pmode']
    ];
}

// Attachments Data
$attachments = []; // Replace with your actual attachments query if needed
?>

<!DOCTYPE html>
<html>
<head>
    <title>View Immovable Property Purchase</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="../css/style.css">
    <link href="boostrap/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <style>
        table { width: 100%; }
        label { width: 53%; font-size: 17px; }
        input { width: 45%; }
        .droplist { width: 45%; }
        h4 { font-size: 17px; color: darkblue; }
        h4:after { content: ":"; }

        table.sales-table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 10px;
            font-family: Arial, sans-serif;
            font-size: 14px;
        }
        table.sales-table th,
        table.sales-table td {
            border: 1px solid #444;
            padding: 6px;
            text-align: center;
            vertical-align: middle;
        }
        table.sales-table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        #attachmentsTable {
            border-collapse: collapse;
            width: 90%;
            margin: 10px auto;
        }
        #attachmentsTable th,
        #attachmentsTable td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: center;
        }
        #attachmentsTable th {
            background-color: #f2f2f2;
        }

        /* Survey & Patta - No border */
        #surveyTable, #pattaTable {
            border-collapse: collapse;
            width: 100%;
        }
        #surveyTable th, #surveyTable td,
        #pattaTable th, #pattaTable td {
            border: 1px solid #444;
            text-align: left;
            padding: 6px;
            font-size: 15px;
        }
    </style>
</head>
<body>
    <center>
        <h2>Immovable Property Purchase - View</h2>
    </center>
    <form>
        <fieldset>
            <table>
                <tr>
                    <td><label>S.No</label><input type="text" value="<?= htmlspecialchars($sno) ?>" readonly></td>
                    <td><label>Company Name</label><input type="text" value="<?= htmlspecialchars($cmpname) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Property Type</label><input type="text" value="<?= htmlspecialchars($propertytype) ?>" readonly></td>
                    <td><label>Pathira No</label><input type="text" value="<?= htmlspecialchars($pathirano) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Registered Date</label><input type="text" value="<?= htmlspecialchars($regdate) ?>" readonly></td>
                    <td><label>Purchase Value</label><input type="text" value="<?= htmlspecialchars($propertyvalue) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Property Place</label><input type="text" value="<?= htmlspecialchars($proplace) ?>" readonly></td>
                    <td><label>Property Village</label><input type="text" value="<?= htmlspecialchars($provillage) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Managing Partner Name</label><input type="text" value="<?= htmlspecialchars($partnername) ?>" readonly></td>
                    <td><label>P.Code</label><input type="text" value="<?= htmlspecialchars($pcode) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Government Value</label><input type="text" value="<?= htmlspecialchars($governmentvalue) ?>" readonly></td>
                    <td><label>Market Value</label><input type="text" value="<?= htmlspecialchars($marketvalue) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Land Category</label><input type="text" value="<?= htmlspecialchars($landtype) ?>" readonly></td>
                    <td></td>
                </tr>
            </table>

            <!-- Survey -->
            <h2>Survey No Details and Property Extent</h2>
            <table>
                <tr>
                    <td>No of Survey Nos</td>
                    <td>Total Extent</td>
                </tr>
                <tr>
                    <td><input type="text" value="<?= $surveyCount ?>" readonly></td>
                    <td><input type="text" value="<?= $surveyExtent ?>" readonly></td>
                </tr>
            </table>
            <table id="surveyTable">
                <thead>
                    <tr><th>Survey No</th><th>Extent</th></tr>
                </thead>
                <tbody>
                    <?php foreach ($surveydet as $row): ?>
                        <tr>
                            <td><input type="text" value="<?= htmlspecialchars($row['surno'] ?? '') ?>" readonly></td>
                            <td><input type="text" value="<?= htmlspecialchars($row['extent'] ?? '') ?>" readonly></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <!-- Patta -->
            <h2>Patta No Details and Property Extent</h2>
            <table>
                <tr>
                    <td>No of Patta Nos</td>
                    <td>Total Extent</td>
                </tr>
                <tr>
                    <td><input type="text" value="<?= $pattaCount ?>" readonly></td>
                    <td><input type="text" value="<?= $pattaExtent ?>" readonly></td>
                </tr>
            </table>
            <table id="pattaTable">
                <thead>
                    <tr><th>Patta No</th><th>Extent</th></tr>
                </thead>
                <tbody>
                    <?php foreach ($pattadet as $row): ?>
                        <tr>
                            <td><input type="text" value="<?= htmlspecialchars($row['no'] ?? '') ?>" readonly></td>
                            <td><input type="text" value="<?= htmlspecialchars($row['extent'] ?? '') ?>" readonly></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <!-- Sales -->
            <h2>Purchase Details</h2>
            <table class="sales-table">
                <tr>
                    <th>S.No</th>
                    <th>Person Name</th>
                    <th>Amount</th>
                    <th>Payment Mode</th>
                </tr>
                <?php foreach ($salesData as $i => $row): ?>
                    <tr>
                        <td><?= $i + 1 ?></td>
                        <td><input type="text" value="<?= htmlspecialchars($row['name']) ?>" readonly></td>
                        <td><input type="number" value="<?= htmlspecialchars($row['amount']) ?>" readonly></td>
                        <td>
                           <input type="text" value="<?= htmlspecialchars($row['pmode']) ?>" readonly>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>

            <!-- Attachments -->
            <h2>Attachments (if Any)</h2>
            <table id="attachmentsTable">
                <tr><th>Type</th><th>File</th><th>Action</th></tr>
                <?php foreach ($attachments as $att): ?>
                    <tr>
                        <td><input type="text" value="<?= htmlspecialchars($att['type']) ?>" readonly></td>
                        <td><input type="text" value="<?= htmlspecialchars($att['filename']) ?>" readonly></td>
                        <td>View Only</td>
                    </tr>
                <?php endforeach; ?>
            </table>

            <!-- Other Details -->
            <h2>Other Details</h2>
            <table style="width:100%;">
                <?php
                $keys = array_keys($otherdet);
                $values = array_values($otherdet);
                for ($i = 0; $i < count($otherdet); $i += 2): ?>
                    <tr>
                        <td style="width:20%; font-size=28px;"><?= htmlspecialchars(strtoupper($keys[$i])) ?></td>
                        <td style="width:30%;"><input type="text" value="<?= htmlspecialchars($values[$i]) ?>" readonly></td>
                        <?php if (isset($keys[$i+1])): ?>
                            <td style="width:20%; font-size=28px;"><?= htmlspecialchars(strtoupper($keys[$i+1])) ?></td>
                            <td style="width:30%;"><input type="text" value="<?= htmlspecialchars($values[$i+1]) ?>" readonly></td>
                        <?php else: ?>
                            <td></td><td></td>
                        <?php endif; ?>
                    </tr>
                <?php endfor; ?>
            </table>
        </fieldset>
    </form>
</body>
</html>
