<?php
include('../check_session.php');
include "../finping.php";

ini_set('display_errors', 1);
error_reporting(E_ALL);

$id = $_GET['id'] ?? '';
if (!$id) {
    echo "Invalid ID.";
    exit;
}

// Fetch sale details
$saleResult = pg_query($db, "SELECT * FROM sac.propsale WHERE id='$id'");
$saleRow = pg_fetch_assoc($saleResult);
if (!$saleRow) {
    echo "Sale not found.";
    exit;
}

$cmpname = $saleRow['cmpname'];
$sno = $saleRow['sno'];
$pathirano = $saleRow['pathirano'];
$regdate = date('d-m-Y', strtotime($saleRow['regdate']));
$propertyvalue = $saleRow['propertyvalue'];
$propertytype = $saleRow['propertytype'];
$provillage = $saleRow['provillage'];
$proplace = $saleRow['proplace'];
$regplace = $saleRow['regplace'];
$regphone = $saleRow['regphone'];
$writername = $saleRow['writername'];
$writerphone = $saleRow['writerphone'];
$partnername = $saleRow['partnername'];
$pcode = $saleRow['pcode'];
$landtype = $saleRow['landtype'];
$purchasevalue = $saleRow['purchasevalue'];
$salespersonnos = $saleRow['salespersonnos'];
$salespersondet = $saleRow['salespersondet'];

// Decode JSON fields safely
$surveydet = json_decode($saleRow['surveydet'], true) ?? [];
$pattadet  = json_decode($saleRow['pattadet'], true) ?? [];
$attachments = json_decode($saleRow['attachment'], true) ?? [];

// Survey stats
$surveyCount = count($surveydet);
$surveyExtent = 0;
foreach ($surveydet as $row) {
    $surveyExtent += (float)$row['extent'];
}

// Patta stats
$pattaCount = count($pattadet);
$pattaExtent = 0;
foreach ($pattadet as $row) {
    $pattaExtent += (float)$row['extent'];
}

// Fetch sales members
$members = [];
$membersResult = pg_query($db, "SELECT * FROM sac.propsalemembers WHERE saleid='$id'");
while ($mrow = pg_fetch_assoc($membersResult)) $members[] = $mrow;
$salesperson_count = count($members);

// Fetch dropdown values
$typeResult = pg_query($db, "SELECT id,name FROM sac.propdropdown WHERE type='propertytype' ORDER BY name");
$proptypes = [];
while ($row = pg_fetch_assoc($typeResult)) {
    $proptypes[] = [
        "id" => $row['id'],
        "typename" => $row['name']
    ];
}
?>
<!DOCTYPE html>
<html>

<head>
    <title>SRI ATHISAKTHI GROUPS</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="../css/style.css">
    <link href="boostrap/css/bootstrap.min.css" rel="stylesheet">

    <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

    <style>
        table {
            width: 100%;
        }

        label {
            width: 53%;
            font-size: 17px;
        }

        input {
            width: 45%;
        }

        .droplist {
            width: 45%;
        }

        .Split {
            border: 1px solid black;
            border-bottom: 1px solid black;
            width: 100px;
        }

        select {
            border: 0 none;
            color: black;
            background: white;
            font-size: 20px;
            padding: 2px 10px;
            width: 378px;
        }

        h4 {
            font-size: 17px;
            color: darkblue;
        }

        h4:after {
            content: ":";
        }

        table.sales-table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 10px;
            font-family: Arial, sans-serif;
            font-size: 14px;
        }

        table.sales-table th,
        table.sales-table td {
            border: 1px solid #444;
            padding: 6px;
            text-align: center;
            vertical-align: middle;
        }

        table.sales-table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        table.sales-table input[type="text"],
        table.sales-table input[type="number"],
        table.sales-table select {
            width: 95%;
            padding: 5px;
            font-size: 14px;
            border: 1px solid #666;
            border-radius: 3px;
            box-sizing: border-box;
        }

        #attachmentsTable {
            border-collapse: collapse;
            width: 90%;
            margin: 10px auto;
        }

        #attachmentsTable th,
        #attachmentsTable td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: center;
        }

        #attachmentsTable th {
            background-color: #f2f2f2;
        }
    </style>

    <script>
        $(function() {
            $("#datepicker,#sdatepicker").datepicker({
                dateFormat: 'dd-mm-yy',
                changeMonth: true,
                changeYear: true
            });
        });

        // Initialize PHP data in JS
        let rowCount = <?= count($attachments) ?>;
        let proptypes = <?= json_encode($proptypes) ?>;
        let surveydet = <?= json_encode($surveydet) ?>;
        let pattadet = <?= json_encode($pattadet) ?>;
        let members = <?= json_encode($members) ?>;
        let attachments = <?= json_encode($attachments) ?>;

        function addRow() {
            let table = document.getElementById("attachmentsTable");
            let row = table.insertRow(-1);
            let typeCell = row.insertCell(0);
            let select = document.createElement("select");
            select.name = `attachments[${rowCount}][type]`;
            select.required = true;
            proptypes.forEach(opt => {
                let o = document.createElement("option");
                o.value = opt.name;
                o.text = opt.name;
                select.appendChild(o);
            });
            typeCell.appendChild(select);

            let fileCell = row.insertCell(1);
            let fileInput = document.createElement("input");
            fileInput.type = "file";
            fileInput.name = `attachments[${rowCount}][file]`;
            fileInput.required = true;
            fileCell.appendChild(fileInput);

            let actionCell = row.insertCell(2);
            let btn = document.createElement("button");
            btn.type = "button";
            btn.innerHTML = "❌ Remove";
            btn.onclick = () => row.remove();
            actionCell.appendChild(btn);

            rowCount++;
        }

        function addSurveyRow(index, surno = '', extent = '') {
            let tbody = document.getElementById('surveyBody');
            let row = document.createElement('tr');
            row.innerHTML = `<td><input type="text" name="survey[${index}][surno]" value="${surno}"></td>
                             <td><input type="text" name="survey[${index}][extent]" value="${extent}" class="survey_extent" oninput="calcSurveyTotal()"></td>`;
            tbody.appendChild(row);
        }

        function loadSurveyData(data) {
            let tbody = document.getElementById('surveyBody');
            tbody.innerHTML = '';
            if (!Array.isArray(data)) return;
            document.getElementById('surveyTable').style.display = 'table';
            data.forEach((row, i) => addSurveyRow(i, row.surno, row.extent));
            calcSurveyTotal();
        }

        function calcSurveyTotal() {
            let total = 0;
            document.querySelectorAll('.survey_extent').forEach(input => total += parseFloat(input.value) || 0);
            document.getElementById('surex').value = total;
        }

        function addPattaRow(index, no = '', extent = '') {
            let tbody = document.getElementById('pattaBody');
            let row = document.createElement('tr');
            row.innerHTML = `<td><input type="text" name="patta[${index}][no]" value="${no}"></td>
                             <td><input type="text" name="patta[${index}][extent]" value="${extent}" class="patta_extent" oninput="calcPattaTotal()"></td>`;
            tbody.appendChild(row);
        }

        function loadPattaData(data) {
            let tbody = document.getElementById('pattaBody');
            tbody.innerHTML = '';
            if (!Array.isArray(data)) return;
            document.getElementById('pattaTable').style.display = 'table';
            data.forEach((row, i) => addPattaRow(i, row.no, row.extent));
            calcPattaTotal();
        }

        function calcPattaTotal() {
            let total = 0;
            document.querySelectorAll('.patta_extent').forEach(input => total += parseFloat(input.value) || 0);
            document.getElementById('patex').value = total;
        }

        function createsalesc(count) {
            let container = document.getElementById("salesInputs");
            container.innerHTML = "";
            count = parseInt(count);
            if (isNaN(count) || count <= 0) return;
            for (let i = 1; i <= count; i++) {
                let row = document.createElement("tr");
                row.innerHTML = `<td>${i}</td>
                                 <td><input type="text" name="sales[${i}][name]" required></td>
                                 <td><input type="number" name="sales[${i}][amount]" class="sales-amount" oninput="calcSalesTotal()" required></td>
                                 <td><select name="sales[${i}][pmode]" required>
                                     <option value="">Select Payment Mode</option>
                                     <option value="Cash">Cash</option>
                                     <option value="SBI Bank Cash">SBI Bank Cash</option>
                                     <option value="SBI Bank Neft">SBI Bank Neft</option>
                                     <option value="SBI Bank Rtgs">SBI Bank Rtgs</option>
                                     <option value="SBI CDM">SBI CDM</option>
                                     <option value="SBI Cheque">SBI Cheque</option>
                                     <option value="SBI DD">SBI DD</option>
                                     <option value="SBI Direct Neft">SBI Direct Neft</option>
                                     <option value="SBI Direct Rtgs">SBI Direct Rtgs</option>
                                     <option value="SBI IMPS">SBI IMPS</option>
                                     <option value="SBI ATM Via">SBI ATM Via</option>
                                 </select></td>`;
                container.appendChild(row);
            }
            calcSalesTotal();
            document.getElementById("salesDataTable").style.display = 'table';
        }

        function calcSalesTotal() {
            let total = 0;
            document.querySelectorAll(".sales-amount").forEach(input => total += parseFloat(input.value) || 0);
            document.getElementById("pur_value").value = total;
        }

        window.onload = function() {
            loadSurveyData(surveydet);
            loadPattaData(pattadet);

            if (members.length > 0) {
                createsalesc(members.length);
                members.forEach((m, i) => {
                    document.querySelector(`input[name='sales[${i+1}][name]']`).value = m.personname;
                    document.querySelector(`input[name='sales[${i+1}][amount]']`).value = m.amount;
                    document.querySelector(`select[name='sales[${i+1}][pmode]']`).value = m.pmode;
                });
                calcSalesTotal();
            }

            let table = document.getElementById("attachmentsTable");
            attachments.forEach((att, i) => {
                let row = table.insertRow(-1);
                row.innerHTML = `<td><input type="text" name="attachments[${i}][type]" value="${att.type}" readonly></td>
                                 <td>${att.filename ? `<a href='uploads/${att.filename}' target='_blank'>${att.filename}</a>` : 'N/A'}</td>
                                 <td><button type="button" onclick="this.closest('tr').remove()">❌ Remove</button></td>`;
            });
        };
    </script>
</head>

<body>
    <center>
        <h2 style='color:maroon;'>Immovable Property Sale</h2>
    </center>
    <form action="salesedit3.php" method="POST" enctype="multipart/form-data">
        <input type='hidden' value='<?= $id ?>' name='id' />

        <fieldset>
            <table>
                <tr>
                    <td><label>Property Type</label>
                        <input type='text' value='<?= $propertytype ?>' name='protype' readonly />
                    </td>
                    <td><label>Pathira No</label>
                        <input type='text' value='<?= $pathirano ?>' name='pathira' />
                    </td>
                </tr>
                <tr>
                    <td><label>Registered Date (DD-MM-YYYY)</label>
                        <input type='text' id='datepicker' value='<?= $regdate ?>' name='rdate' />
                    </td>
                    <td><label>Purchase Value</label>
                        <input type='text' value='<?= $propertyvalue ?>' name='salevalue' required />
                    </td>
                </tr>
            </table>
        </fieldset>

        <fieldset>
            <h2 style='color:red'>Survey No Details and Property Extent</h2>
            <table>
                <tr>
                    <td><label>No of Survey Nos</label>
                        <input type='text' name='nosur' value='<?= $surveyCount ?>' id='nosur'>
                    </td>
                    <td><label>Survey Nos Total Extent</label>
                        <input type='text' id='surex' value='<?= $surveyExtent ?>' name='surex' readonly />
                    </td>
                </tr>
            </table>
            <table id='surveyTable' style='border-collapse:collapse; width:100%; margin-top:10px;' border='1' style='display:none;'>
                <thead style='background:#f2f2f2;'>
                    <tr>
                        <th style='padding:8px; text-align:center;'>Survey No</th>
                        <th style='padding:8px; text-align:center;'>Extent</th>
                    </tr>
                </thead>
                <tbody id='surveyBody'></tbody>
            </table>
        </fieldset>

        <fieldset>
            <h2 style='color:red'>Patta No Details and Property Extent</h2>
            <table>
                <tr>
                    <td><label>No of Patta Nos</label>
                        <input type='text' id='nopat' value='<?= $pattaCount ?>' name='nopat'>
                    </td>
                    <td><label>Patta Nos Total Extent</label>
                        <input type='text' id='patex' name='patex' value='<?= $pattaExtent ?>' readonly>
                    </td>
                </tr>
            </table>
            <table id='pattaTable' style='border-collapse:collapse; width:100%; margin-top:10px; display:none;' border='1' style='display:none;'>
                <thead style='background:#f2f2f2;'>
                    <tr>
                        <th style='padding:8px; text-align:center;'>Patta No</th>
                        <th style='padding:8px; text-align:center;'>Extent</th>
                    </tr>
                </thead>
                <tbody id='pattaBody'></tbody>
            </table>
        </fieldset>

        <fieldset>
            <h2 style='color:red'>Sale Details</h2>
            <table>
                <tr>
                    <td><label>Sale Person Count</label>
                        <input type='number' name='sales_per_no' id='salesperson1' onchange='createsalesc(this.value);' value='<?= $salesperson_count  ?>'>
                    </td>
                    <td><label>Total Purchase Value</label>
                        <input type='number' name='pur_value' id='pur_value'>
                    </td>
                </tr>
            </table>
            <table id='salesDataTable' class='sales-table' style='display:none;'>
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Person Name</th>
                        <th>Amount</th>
                        <th>Mode of Payment</th>
                    </tr>
                </thead>
                <tbody id='salesInputs'></tbody>
            </table>
        </fieldset>

        <fieldset>
            <h2 style='color:red'>Attachments (if Any)</h2>
            <table id='attachmentsTable'>
                <tr>
                    <th>Type</th>
                    <th>File</th>
                    <th>Action</th>
                </tr>
            </table>
            <button type='button' onclick='addRow()'>➕ Add</button>
        </fieldset>

        <center><button type='submit' class='submit'>Submit</button></center>
    </form>
</body>

</html>