<?php
include "../finping.php";

$id = $_GET['id'] ?? '';
if (!$id) {
    echo "Invalid ID.";
    exit;
}

// Fetch sale details
$saleResult = pg_query($db, "SELECT * FROM sac.propsale WHERE id='$id'");
$saleRow = pg_fetch_assoc($saleResult);
if (!$saleRow) {
    echo "Sale not found.";
    exit;
}

// Decode JSON fields
$attachments = json_decode($saleRow['attachment'], true) ?? [];
$surveydet = json_decode($saleRow['surveydet'], true) ?? [];
$pattadet  = json_decode($saleRow['pattadet'], true) ?? [];

// Fetch sales members
$membersResult = pg_query($db, "SELECT * FROM sac.propsalemembers WHERE saleid='$id'");
$members = [];
while ($mrow = pg_fetch_assoc($membersResult)) $members[] = $mrow;

// Fetch dropdowns
$typeResult = pg_query($db, "SELECT id,name FROM sac.propdropdown WHERE type='propertytype' ORDER BY name");
$proptypes = [];
while ($row = pg_fetch_assoc($typeResult)) $proptypes[] = $row;

// Survey & Patta totals
$surveyCount = count($surveydet);
$surveyExtent = array_sum(array_map(fn($r) => (float)$r['extent'], $surveydet));

$pattaCount = count($pattadet);
$pattaExtent = array_sum(array_map(fn($r) => (float)$r['extent'], $pattadet));

?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Edit Sale</title>
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <style>
        /* --- Preserve Purchase Edit UI --- */
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }

        table input,
        table select {
            width: 95%;
            padding: 5px;
            font-size: 14px;
        }

        table th,
        table td {
            border: 1px solid #ccc;
            padding: 6px;
            text-align: center;
        }

        h2 {
            color: red;
            margin: 10px 0;
        }

        button {
            padding: 5px 10px;
            margin: 5px;
        }
    </style>
    <script>
        $(function() {
            $("#datepicker,#sdatepicker").datepicker({
                dateFormat: 'dd-mm-yy',
                changeMonth: true,
                changeYear: true
            });
        });

        let rowCount = <?= count($attachments) ?>;

        function addRow() {
            let table = document.getElementById("attachmentsTable");
            let row = table.insertRow(-1);
            let typeCell = row.insertCell(0);
            let select = document.createElement("select");
            select.name = `attachments[${rowCount}][type]`;
            select.required = true;
            let typeOptions = <?= json_encode($proptypes) ?>;
            typeOptions.forEach(opt => {
                let o = document.createElement("option");
                o.value = opt.name;
                o.text = opt.name;
                select.appendChild(o);
            });
            typeCell.appendChild(select);
            let fileCell = row.insertCell(1);
            let fileInput = document.createElement("input");
            fileInput.type = "file";
            fileInput.name = `attachments[${rowCount}][file]`;
            fileInput.required = true;
            fileCell.appendChild(fileInput);
            let actionCell = row.insertCell(2);
            let btn = document.createElement("button");
            btn.type = "button";
            btn.innerHTML = "❌ Remove";
            btn.onclick = () => row.remove();
            actionCell.appendChild(btn);
            rowCount++;
        }

        // Survey functions
        function addSurveyRow(index, surno = '', extent = '') {
            let tbody = document.getElementById('surveyBody');
            let row = document.createElement('tr');
            row.innerHTML = `<td><input type="text" name="survey[${index}][surno]" value="${surno}"></td><td><input type="text" name="survey[${index}][extent]" value="${extent}" class="survey_extent" oninput="calcSurveyTotal()"></td>`;
            tbody.appendChild(row);
        }

        function loadSurveyData(data) {
            let tbody = document.getElementById('surveyBody');
            tbody.innerHTML = '';
            if (!Array.isArray(data)) return;
            document.getElementById('surveyTable').style.display = 'table';
            data.forEach((row, i) => addSurveyRow(i, row.surno, row.extent));
            calcSurveyTotal();
        }

        function calcSurveyTotal() {
            let total = 0;
            document.querySelectorAll('.survey_extent').forEach(input => total += parseFloat(input.value) || 0);
            document.getElementById('surex').value = total;
        }

        // Patta functions
        function addPattaRow(index, no = '', extent = '') {
            let tbody = document.getElementById('pattaBody');
            let row = document.createElement('tr');
            row.innerHTML = `<td><input type="text" name="patta[${index}][no]" value="${no}"></td><td><input type="text" name="patta[${index}][extent]" value="${extent}" class="patta_extent" oninput="calcPattaTotal()"></td>`;
            tbody.appendChild(row);
        }

        function loadPattaData(data) {
            let tbody = document.getElementById('pattaBody');
            tbody.innerHTML = '';
            if (!Array.isArray(data)) return;
            document.getElementById('pattaTable').style.display = 'table';
            data.forEach((row, i) => addPattaRow(i, row.no, row.extent));
            calcPattaTotal();
        }

        function calcPattaTotal() {
            let total = 0;
            document.querySelectorAll('.patta_extent').forEach(input => total += parseFloat(input.value) || 0);
            document.getElementById('patex').value = total;
        }

        // Sales Members
        function createsalesc(count) {
            let container = document.getElementById("salesInputs");
            container.innerHTML = "";
            count = parseInt(count);
            if (isNaN(count) || count <= 0) return;
            for (let i = 1; i <= count; i++) {
                let row = document.createElement("tr");
                row.innerHTML = `<td>${i}</td><td><input type="text" name="sales[${i}][name]" required></td><td><input type="number" name="sales[${i}][amount]" class="sales-amount" oninput="calcSalesTotal()" required></td><td><select name="sales[${i}][pmode]" required><option value="">Select Payment Mode</option><option value="Cash">Cash</option><option value="SBI Bank Cash">SBI Bank Cash</option><option value="SBI Bank Neft">SBI Bank Neft</option><option value="SBI Bank Rtgs">SBI Bank Rtgs</option><option value="SBI CDM">SBI CDM</option><option value="SBI Cheque">SBI Cheque</option><option value="SBI DD">SBI DD</option><option value="SBI Direct Neft">SBI Direct Neft</option><option value="SBI Direct Rtgs">SBI Direct Rtgs</option><option value="SBI IMPS">SBI IMPS</option><option value="SBI ATM Via">SBI ATM Via</option></select></td>`;
                container.appendChild(row);
            }
            calcSalesTotal();
        }

        function calcSalesTotal() {
            let total = 0;
            document.querySelectorAll(".sales-amount").forEach(input => total += parseFloat(input.value) || 0);
            document.getElementById("pur_value").value = total;
        }

        window.onload = function() {
            loadSurveyData(<?= json_encode($surveydet) ?>);
            loadPattaData(<?= json_encode($pattadet) ?>);
            let members = <?= json_encode($members) ?>;
            if (members.length > 0) {
                createsalesc(members.length);
                members.forEach((m, i) => {
                    document.querySelector(`input[name='sales[${i+1}][name]']`).value = m.personname;
                    document.querySelector(`input[name='sales[${i+1}][amount]']`).value = m.amount;
                    document.querySelector(`select[name='sales[${i+1}][pmode]']`).value = m.pmode;
                });
                calcSalesTotal();
            }
            let attachments = <?= json_encode($attachments) ?>;
            let table = document.getElementById("attachmentsTable");
            attachments.forEach((att, i) => {
                let row = table.insertRow(-1);
                row.innerHTML = `<td><input type="text" name="attachments[${i}][type]" value="${att.type}" readonly></td><td>${att.filename?`<a href='uploads/${att.filename}' target='_blank'>${att.filename}</a>`:'N/A'}</td><td><button type="button" onclick="this.closest('tr').remove()">❌ Remove</button></td>`;
            });
        };
    </script>
</head>

<body>
    <center><h2 style='color:maroon;'>Immovable Property Sale</h2></center>
    <form action="salesedit3.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="id" value="<?= $id ?>">
        <fieldset>
            <h2>Property Details</h2>
            <table>
                <tr>
                    <td>Property Type</td>
                    <td><input type="text" name="propertytype" value="<?= htmlspecialchars($saleRow['propertytype']) ?>" readonly></td>
                </tr>
                <tr>
                    <td>Purchase Value</td>
                    <td><input type="text" name="salevalue" value="<?= htmlspecialchars($saleRow['propertyvalue']) ?>" required></td>
                </tr>
                <tr>
                    <td>Pathira No</td>
                    <td><input type="text" name="pathira" value="<?= htmlspecialchars($saleRow['pathirano']) ?>"></td>
                </tr>
                <tr>
                    <td>Registered Date</td>
                    <td><input type="text" name="rdate" id="datepicker" value="<?= $saleRow['regdate'] ?>"></td>
                </tr>
            </table>
        </fieldset>

        <fieldset>
            <h2>Survey Details</h2>
            <table>
                <tr>
                    <td>No of Survey Nos</td>
                    <td><input type="text" id="nosur" value="<?= $surveyCount ?>" onchange="createSurvey(this.value)"></td>
                </tr>
                <tr>
                    <td>Total Extent</td>
                    <td><input type="text" id="surex" value="<?= $surveyExtent ?>" readonly></td>
                </tr>
            </table>
            <table id="surveyTable" style="display:none">
                <thead>
                    <tr>
                        <th>Survey No</th>
                        <th>Extent</th>
                    </tr>
                </thead>
                <tbody id="surveyBody"></tbody>
            </table>
        </fieldset>

        <fieldset>
            <h2>Patta Details</h2>
            <table>
                <tr>
                    <td>No of Patta Nos</td>
                    <td><input type="text" id="nopat" value="<?= $pattaCount ?>" onchange="createPatta(this.value)"></td>
                </tr>
                <tr>
                    <td>Total Extent</td>
                    <td><input type="text" id="patex" value="<?= $pattaExtent ?>" readonly></td>
                </tr>
            </table>
            <table id="pattaTable" style="display:none">
                <thead>
                    <tr>
                        <th>Patta No</th>
                        <th>Extent</th>
                    </tr>
                </thead>
                <tbody id="pattaBody"></tbody>
            </table>
        </fieldset>

        <fieldset>
            <h2>Sales Details</h2>
            <table>
                <tr>
                    <td>No of Persons</td>
                    <td><input type="text" id="salesperson1" value="<?= count($members) ?>" onchange="createsalesc(this.value)"></td>
                </tr>
                <tr>
                    <td>Total Sales Value</td>
                    <td><input type="text" id="pur_value" name="pur_value" readonly></td>
                </tr>
            </table>
            <table id="salesDataTable" class="sales-table">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Name</th>
                        <th>Amount</th>
                        <th>Mode</th>
                    </tr>
                </thead>
                <tbody id="salesInputs"></tbody>
            </table>
        </fieldset>

        <fieldset>
            <h2>Attachments</h2>
            <table id="attachmentsTable">
                <tr>
                    <th>Type</th>
                    <th>File</th>
                    <th>Action</th>
                </tr>
            </table>
            <button type="button" onclick="addRow()">➕ Add</button>
        </fieldset>

        <center><button type="submit">Update Sale</button></center>
    </form>
</body>

</html>