<?php
include "../finping.php";

$id = $_POST['id'] ?? '';
if (!$id) { echo "Invalid ID."; exit; }

// --- Gather Property Details ---
$propertytype = $_POST['propertytype'] ?? '';
$salevalue    = $_POST['salevalue'] ?? 0;
$pathira      = $_POST['pathira'] ?? '';
$rdate        = $_POST['rdate'] ?? '';
$regdate      = !empty($rdate) ? date('Y-m-d', strtotime(str_replace('-', '/', $rdate))) : null;

// --- Gather Survey & Patta ---
$surveys = $_POST['survey'] ?? [];
$pattas  = $_POST['patta'] ?? [];

// Encode as JSON
$surveydet_json = json_encode($surveys);
$pattadet_json  = json_encode($pattas);

// --- Handle Attachments ---
$existingAttachments = json_decode($_POST['existing_attachments'] ?? '[]', true) ?? [];
$newAttachments = [];

// Upload new files
if(!empty($_FILES['attachments']['name'])){
    foreach($_FILES['attachments']['name'] as $i => $files){
        $type = $_POST['attachments'][$i]['type'] ?? '';
        $fileName = $_FILES['attachments']['name'][$i];
        $tmpName  = $_FILES['attachments']['tmp_name'][$i];

        if($fileName){
            $targetDir = "uploads/";
            if(!is_dir($targetDir)) mkdir($targetDir,0777,true);
            $targetFile = $targetDir . basename($fileName);
            if(move_uploaded_file($tmpName, $targetFile)){
                $newAttachments[] = ['type'=>$type, 'filename'=>$fileName];
            }
        }
    }
}

// Merge existing + new
$attachments_json = json_encode(array_merge($existingAttachments, $newAttachments));

// --- Update propsale ---
$updateQuery = "UPDATE sac.propsale SET propertytype=$1, propertyvalue=$2, pathirano=$3, regdate=$4, surveydet=$5, pattadet=$6, attachment=$7 WHERE id=$8";
$result = pg_query_params($db, $updateQuery, [
    $propertytype, $salevalue, $pathira, $regdate, $surveydet_json, $pattadet_json, $attachments_json, $id
]);

if(!$result){ echo "Failed to update sale."; exit; }

// --- Update propsalemembers ---
// Delete old members
pg_query_params($db, "DELETE FROM sac.propsalemembers WHERE saleid=$1", [$id]);

// Insert new members
$sales = $_POST['sales'] ?? [];
foreach($sales as $member){
    $name   = $member['name'] ?? '';
    $amount = $member['amount'] ?? 0;
    $pmode  = $member['pmode'] ?? '';
    if($name){
        pg_query_params($db, "INSERT INTO sac.propsalemembers(saleid,personname,amount,pmode) VALUES($1,$2,$3,$4)", [$id, $name, $amount, $pmode]);
    }
}

echo "<script>alert('Sale updated successfully'); window.location='salesedit.php';</script>";
?>
