<?php
include('../check_session.php');
include "../finping.php";

$id = $_GET['id'] ?? '';
if (!$id) {
    echo "Invalid Sale ID.";
    exit;
}

// Fetch sale master record
$saleResult = pg_query($db, "SELECT * FROM sac.propsale WHERE id='$id'");
$sale = pg_fetch_assoc($saleResult);
if (!$sale) {
    echo "Sale not found.";
    exit;
}

// Decode JSON fields
$surveydet = json_decode($sale['surveydet'], true) ?? [];
$pattadet = json_decode($sale['pattadet'], true) ?? [];
$otherdet = json_decode($sale['otherdet'], true) ?? [];

// Survey stats
$surveyCount = count($surveydet);
$surveyExtent = array_sum(array_map(fn($s) => floatval($s['extent'] ?? 0), $surveydet));

// Patta stats
$pattaCount = count($pattadet);
$pattaExtent = array_sum(array_map(fn($p) => floatval($p['extent'] ?? 0), $pattadet));

// Fetch sale members
$saleMembers = [];
$smResult = pg_query($db, "SELECT * FROM sac.propsalemembers WHERE saleid='$id'");
while ($row = pg_fetch_assoc($smResult)) {
    $saleMembers[] = $row;
}
$purid=$sale['purchaseid'];
$pprResult = pg_query($db, "SELECT * FROM sac.proppurchase WHERE id='$purid'");
$ppr = pg_fetch_assoc($pprResult);
?>
<!DOCTYPE html>
<html>

<head>
    <title>View Property Sale</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="../css/style.css">
    <link href="boostrap/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <style>
        table {
            width: 100%;
        }

        input,
        select {
            width: 95%;
            padding: 4px;
            font-size: 14px;
        }

        label {
            font-weight: bold;
            margin-right: 10px;
        }

        table.sales-table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 10px;
        }

        table.sales-table th,
        table.sales-table td {
            border: 1px solid #444;
            padding: 6px;
            text-align: center;
        }

        table.sales-table th {
            background: #f2f2f2;
        }

        table#surveyTable,
        table#pattaTable {
            border-collapse: collapse;
            width: 100%;
            margin-top: 10px;
        }

        table#surveyTable th,
        table#surveyTable td,
        table#pattaTable th,
        table#pattaTable td {
            border: 1px solid #444;
            padding: 6px;
            text-align: center;
        }
    </style>
</head>

<body>
    <center>
        <h2 style="color:maroon;">Property Sale Details</h2>
    </center>
    <form>
        <fieldset>
            <table>
                <tr>
                    <td><label>S.No</label><input type="text" value="<?= htmlspecialchars($sale['sno']) ?>" readonly></td>
                    <td><label>Company Name</label><input type="text" value="<?= htmlspecialchars($sale['cmpname']) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Property Type</label><input type="text" value="<?= htmlspecialchars($sale['propertytype']) ?>" readonly></td>
                    <td><label>Pathira No</label><input type="text" value="<?= htmlspecialchars($sale['pathirano']) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Registered Date</label><input type="text" value="<?= date('d-m-Y', strtotime($sale['regdate'])) ?>" readonly></td>
                    <td><label>Purchase Value</label><input type="text" value="<?= htmlspecialchars($sale['propertyvalue']) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Property Place</label><input type="text" value="<?= htmlspecialchars($sale['proplace']) ?>" readonly></td>
                    <td><label>Property Village</label><input type="text" value="<?= htmlspecialchars($sale['provillage']) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Managing Partner</label><input type="text" value="<?= htmlspecialchars($sale['partnername']) ?>" readonly></td>
                    <td><label>P.Code</label><input type="text" value="<?= htmlspecialchars($sale['pcode']) ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Government Value</label><input type="text" value="<?=$ppr['governmentvalue'] ?>" readonly></td>
                    <td><label>Market Value</label><input type="text" value="<?= $ppr['marketvalue'] ?>" readonly></td>
                </tr>
                <tr>
                    <td><label>Land Category</label><input type="text" value="<?= htmlspecialchars($sale['landtype']) ?>" readonly></td>
                    <td><label>Tax</label><input type="text" value="<?= $sale['tax'] ?>" readonly></td>
                </tr>
            </table>

            <!-- Survey -->
            <h2>Survey No Details</h2>
            <label>No of Survey Nos</label> <input type="text" value="<?= $surveyCount ?>" readonly>
            <label>Total Extent</label> <input type="text" value="<?= $surveyExtent ?>" readonly>
            <table id="surveyTable">
                <tbody>
                    <?php foreach ($surveydet as $s): ?>
                        <tr>
                            <td><input type="text" value="<?= htmlspecialchars($s['surno'] ?? '') ?>" readonly></td>
                            <td><input type="text" value="<?= htmlspecialchars($s['extent'] ?? '') ?>" readonly></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <!-- Patta -->
            <h2>Patta No Details</h2>
            <label>No of Patta Nos</label> <input type="text" value="<?= $pattaCount ?>" readonly>
            <label>Total Extent</label> <input type="text" value="<?= $pattaExtent ?>" readonly>
            <table id="pattaTable">
                <tbody>
                    <?php foreach ($pattadet as $p): ?>
                        <tr>
                            <td><input type="text" value="<?= htmlspecialchars($p['no'] ?? '') ?>" readonly></td>
                            <td><input type="text" value="<?= htmlspecialchars($p['extent'] ?? '') ?>" readonly></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </fieldset>

        <!-- Sale Members -->
        <fieldset>
            <h2>Sales Members</h2>
            <table class="sales-table">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Person Name</th>
                        <th>Amount</th>
                        <th>Payment Mode</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($saleMembers as $i => $m): ?>
                        <tr>
                            <td><?= $i + 1 ?></td>
                            <td><input type="text" value="<?= htmlspecialchars($m['personname']) ?>" readonly></td>
                            <td><input type="number" value="<?= htmlspecialchars($m['amount']) ?>" readonly></td>
                            <td><input type="text" value="<?= htmlspecialchars($m['pmode']) ?>" readonly></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </fieldset>

        <!-- Other Details -->
        <!-- <fieldset>
            <h2>Other Details</h2>
            <table>
                <?php
                $keys = array_keys($otherdet);
                $values = array_values($otherdet);
                for ($i = 0; $i < count($otherdet); $i += 2): ?>
                    <tr>
                        <td><?= htmlspecialchars($keys[$i]) ?></td>
                        <td><input type="text" value="<?= htmlspecialchars($values[$i]) ?>" readonly></td>
                        <?php if (isset($keys[$i + 1])): ?>
                            <td><?= htmlspecialchars($keys[$i + 1]) ?></td>
                            <td><input type="text" value="<?= htmlspecialchars($values[$i + 1]) ?>" readonly></td>
                        <?php else: ?>
                            <td></td>
                            <td></td>
                        <?php endif; ?>
                    </tr>
                <?php endfor; ?>
            </table>
        </fieldset> -->
    </form>
</body>

</html>