<?php
$dt2 = '2025-12-26';
$lastd = '2026-02-28';

echo "Start: $dt2\n";
echo "End: $lastd\n";

$start = DateTime::createFromFormat('Y-m-d', $dt2);
$end   = DateTime::createFromFormat('Y-m-d', $lastd);

/* Treat 30th as month-end if month has 31 days */
$endDay = (int) $end->format('d');
$daysInEndMonth = (int) $end->format('t');

echo "End Day: $endDay, DaysInEndMonth: $daysInEndMonth\n";

if ($endDay == 30 && $daysInEndMonth == 31) {
    echo "Modifying end date (30->31)\n";
    $end->modify('last day of this month');
    // $intdate=DateTime::createFromFormat('Y-m-d', $end); // This line in user code is buggy effectively but let's ignore the variable assignment for diff calculation
}

$diff = $start->diff($end);

$months = ($diff->y * 12) + $diff->m;
$days   = $diff->d;

echo "Initial Diff: Months: $months, Days: $days\n";

/* 🔥 FINANCE FIX: 30th → month end = full month */
$startDay = (int)$start->format('d');
$endDay   = (int)$end->format('d');
$endLast  = (int)$end->format('t');

if ($startDay >= 30 && $endDay == $endLast && $days > 0) {
    echo "Condition 1 met\n";
    $days = 0;   // 🔥 kill extra day
}
if ($days == 30) {
    echo "Days is 30 -> increment month\n";
    $months++;
    $days = 0;
}

if ((int)$start->format('d') == 1 && $days > 0) {
    echo "Start is 1st -> increment month\n";
    $months++;
    $days = 0;
}

echo "Result: $months / $days\n";
